local ScenarioUtils = import('/lua/sim/ScenarioUtilities.lua')
local ScenarioFramework = import('/lua/ScenarioFramework.lua')

function OnPopulate()
    ScenarioUtils.InitializeArmies()
    ScenarioFramework.SetPlayableArea('AREA_1' , false)
end

function OnStart(scenario)
	ForkThread(RevealCivilians)
end

function RevealCivilians()
	local brain = GetArmyBrain('NEUTRAL_CIVILIAN')
	local UnitsInBrain = brain:GetListOfUnits(categories.ALLUNITS, true)
	local NumberOfUnitsInBrain = table.getn(UnitsInBrain)
	local armies = ListArmies()
	for unit = 1, NumberOfUnitsInBrain, 1 do
		local UnitPosition = UnitsInBrain[unit]:GetPosition()
		for i, army in armies do
			ScenarioFramework.CreateVisibleAreaLocation(2, UnitPosition, 45, GetArmyBrain(army))
		end
	end
end
